/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.common.network.InventorySlotSyncPacket;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;

public class MeltingModule
extends SingleStackStorage
implements IMeltingContainer,
class_3913 {
    public static final int NO_SPACE = -1;
    private static final String TAG_CURRENT_TIME = "time";
    private static final String TAG_REQUIRED_TIME = "required";
    private static final String TAG_REQUIRED_TEMP = "temp";
    private static final int CURRENT_TIME = 0;
    private static final int REQUIRED_TIME = 1;
    private static final int REQUIRED_TEMP = 2;
    private final MantleBlockEntity parent;
    private final Predicate<IMeltingRecipe> outputFunction;
    private final IMeltingContainer.IOreRate oreRate;
    private final int slotIndex;
    private int currentTime = 0;
    private int requiredTime = 0;
    private int requiredTemp = 0;
    private IMeltingRecipe lastRecipe;
    private class_1799 stack = class_1799.field_8037;

    @Override
    public IMeltingContainer.IOreRate getOreRate() {
        return this.oreRate;
    }

    private void resetRecipe() {
        this.currentTime = 0;
        this.requiredTime = 0;
        this.requiredTemp = 0;
    }

    public void setStack(class_1799 newStack) {
        IMeltingRecipe recipe;
        class_1937 world = this.parent.method_10997();
        if (this.slotIndex != -1 && world != null && !world.field_9236 && !class_1799.method_7973((class_1799)this.stack, (class_1799)newStack)) {
            TinkerNetwork.getInstance().sendToClientsAround((S2CPacket)new InventorySlotSyncPacket(newStack, this.slotIndex, this.parent.method_11016()), (class_1936)world, this.parent.method_11016());
        }
        if (newStack.method_7960()) {
            this.resetRecipe();
        } else if (this.stack.method_7960() || !ItemHandlerHelper.canItemStacksStack((class_1799)this.stack, (class_1799)newStack)) {
            this.currentTime = 0;
        }
        this.stack = newStack;
        int newTime = 0;
        int newTemp = 0;
        if (!this.stack.method_7960() && (recipe = this.findRecipe()) != null) {
            newTime = recipe.getTime(this) * 10;
            newTemp = recipe.getTemperature(this);
        }
        this.requiredTime = newTime;
        this.requiredTemp = newTemp;
        this.parent.setChangedFast();
    }

    public boolean canHeatItem(int temperature) {
        if (this.requiredTime > 0) {
            if (this.stack.method_7960()) {
                this.resetRecipe();
                return false;
            }
            return this.currentTime != -1 && temperature >= this.requiredTemp;
        }
        return false;
    }

    public void heatItem(int temperature) {
        if (this.currentTime == -1 || this.canHeatItem(temperature)) {
            if (this.currentTime == -1 || this.currentTime >= this.requiredTime) {
                if (this.onItemFinishedHeating()) {
                    this.resetRecipe();
                }
            } else {
                this.currentTime += temperature / 100;
            }
        }
    }

    public void coolItem() {
        if (this.currentTime == -1) {
            if (this.onItemFinishedHeating()) {
                this.resetRecipe();
            }
        } else if (this.currentTime > 0 && this.requiredTime > 0) {
            this.currentTime -= 5;
        }
    }

    @Nullable
    private IMeltingRecipe findRecipe() {
        class_1937 world = this.parent.method_10997();
        if (world == null) {
            return null;
        }
        IMeltingRecipe last = this.lastRecipe;
        if (last != null && last.method_8115(this, world)) {
            return last;
        }
        Optional newRecipe = world.method_8433().method_8132((class_3956)TinkerRecipeTypes.MELTING.get(), (class_1263)this, world);
        if (newRecipe.isPresent()) {
            this.lastRecipe = (IMeltingRecipe)newRecipe.get();
            return this.lastRecipe;
        }
        return null;
    }

    private boolean onItemFinishedHeating() {
        IMeltingRecipe recipe = this.findRecipe();
        if (recipe == null) {
            return true;
        }
        if (this.outputFunction.test(recipe)) {
            this.setStack(class_1799.field_8037);
            return true;
        }
        this.currentTime = -1;
        return false;
    }

    public class_2487 writeToTag() {
        class_2487 nbt = new class_2487();
        if (!this.stack.method_7960()) {
            this.stack.method_7953(nbt);
            nbt.method_10569(TAG_CURRENT_TIME, this.currentTime);
            nbt.method_10569(TAG_REQUIRED_TIME, this.requiredTime);
            nbt.method_10569(TAG_REQUIRED_TEMP, this.requiredTemp);
        }
        return nbt;
    }

    public void readFromTag(class_2487 nbt) {
        this.stack = class_1799.method_7915((class_2487)nbt);
        if (!this.stack.method_7960()) {
            this.currentTime = nbt.method_10550(TAG_CURRENT_TIME);
            this.requiredTime = nbt.method_10550(TAG_REQUIRED_TIME);
            this.requiredTemp = nbt.method_10550(TAG_REQUIRED_TEMP);
        }
    }

    public int method_17389() {
        return 3;
    }

    public int method_17390(int index) {
        return switch (index) {
            case 0 -> this.currentTime;
            case 1 -> this.requiredTime;
            case 2 -> this.requiredTemp;
            default -> 0;
        };
    }

    public void method_17391(int index, int value) {
        switch (index) {
            case 0: {
                this.currentTime = value;
                break;
            }
            case 1: {
                this.requiredTime = value;
                break;
            }
            case 2: {
                this.requiredTemp = value;
            }
        }
    }

    protected int getCapacity(ItemVariant itemVariant) {
        return 1;
    }

    public MeltingModule(MantleBlockEntity parent, Predicate<IMeltingRecipe> outputFunction, IMeltingContainer.IOreRate oreRate, int slotIndex) {
        this.parent = parent;
        this.outputFunction = outputFunction;
        this.oreRate = oreRate;
        this.slotIndex = slotIndex;
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public int getRequiredTime() {
        return this.requiredTime;
    }

    public int getRequiredTemp() {
        return this.requiredTemp;
    }

    @Override
    public class_1799 getStack() {
        return this.stack;
    }
}

